import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/add_service/add_service_master_provider.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:auto_route/auto_route.dart';
import 'package:flutter/material.dart';
import 'package:flutter_staggered_animations/flutter_staggered_animations.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import '../../../../comments/widgets/no_item.dart';
import 'service_list_item.dart';

class ServicesModal extends ConsumerStatefulWidget {
  final ValueChanged<ServiceData> onChange;

  const ServicesModal({super.key, required this.onChange});

  @override
  ConsumerState<ServicesModal> createState() => _ServicesModalState();
}

class _ServicesModalState extends ConsumerState<ServicesModal> {
  late RefreshController _refreshController;

  @override
  void initState() {
    super.initState();
    _refreshController = RefreshController();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) {
        if (ref.watch(addServiceMasterProvider).services.isEmpty) {
          ref
              .read(addServiceMasterProvider.notifier)
              .fetchAllServices(isRefresh: true, context: context);
        }
      },
    );
  }

  @override
  void dispose() {
    super.dispose();
    _refreshController.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(addServiceMasterProvider);
    final notifier = ref.read(addServiceMasterProvider.notifier);
    return Container(
      constraints: BoxConstraints(
        maxHeight: MediaQuery.of(context).size.height / 1.4,
        maxWidth: 280,
      ),
      child: SingleChildScrollView(
        child: Column(
          children: [
            state.isLoading
                ? Padding(padding: EdgeInsets.all(32), child: const Loading())
                : state.allServices.isEmpty
                    ? const NoItem(title: TrKeys.noService)
                    : AnimationLimiter(
                        child: ListView.builder(
                          padding: REdgeInsets.symmetric(
                              horizontal: 16, vertical: 12),
                          physics: const NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          itemCount: state.allServices.length,
                          itemBuilder: (context, index) =>
                              AnimationConfiguration.staggeredList(
                            position: index,
                            duration: AppConstants.animationDuration,
                            child: ScaleAnimation(
                              scale: 0.5,
                              child: FadeInAnimation(
                                child: ServiceListItem(
                                  service: state.allServices[index],
                                  spacing: 10,
                                  onTap: () {
                                    widget.onChange
                                        .call(state.allServices[index]);
                                    context.maybePop();
                                  },
                                ),
                              ),
                            ),
                          ),
                        ),
                      ),
            // 12.verticalSpace,
            if (state.hasMore)
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 12),
                child: state.isLoading
                    ? SizedBox.shrink()
                    : HasMoreButton(
                        hasMore: state.hasMore,
                        onViewMore: () {
                          notifier.fetchAllServices(
                            context: context,
                            controller: _refreshController,
                          );
                        }),
              ),
            12.verticalSpace,
          ],
        ),
      ),
    );
  }
}

